/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.scripting.BundleConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetConverter {
    public static void main(String[] args) throws Exception {
        String userHome = System.getProperty("user.home");
        if (args == null || args.length == 0) {
            args = new String[]{String.valueOf(userHome) + "/Documents/Aptana Rubles/rails.ruble/Snippets"};
        }
        String outputFilePath = args.length < 2 ? String.valueOf(userHome) + "/Documents/Aptana Rubles/rails.ruble/Snippets/snippets.rb" : args[1];
        SnippetConverter.convert(new File(args[0]), outputFilePath);
    }

    private static List<String> convert(File snippetDirectory) {
        ArrayList<String> snippets = new ArrayList<String>();
        File[] plistFiles = SnippetConverter.findSnippetFiles(snippetDirectory);
        if (plistFiles == null) {
            return snippets;
        }
        File[] fileArray = plistFiles;
        int n = plistFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File plistFile = fileArray[n2];
            try {
                Map<String, Object> properties = BundleConverter.parse(plistFile);
                if (properties != null) {
                    String scope;
                    String name = BundleConverter.sanitize(properties, "name");
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("snippet '").append(name).append("' do |s|\n");
                    String trigger = BundleConverter.sanitize(properties, "tabTrigger");
                    if (trigger != null) {
                        buffer.append("  s.trigger = '").append(trigger).append("'\n");
                    } else {
                        buffer.append("  # FIXME No tab trigger, probably needs to become command\n");
                    }
                    String keyBinding = BundleConverter.sanitize(properties, "keyEquivalent");
                    if (keyBinding != null) {
                        keyBinding = BundleConverter.convertKeyBinding(keyBinding);
                        buffer.append("  s.key_binding = '").append(keyBinding).append("'\n");
                    }
                    if ((scope = BundleConverter.sanitize(properties, "scope")) != null) {
                        buffer.append("  s.scope = '").append(scope).append("'\n");
                    }
                    String content = BundleConverter.sanitize(properties, "content");
                    buffer.append("  s.expansion = '").append(content).append("'\n");
                    buffer.append("end\n\n");
                    snippets.add(buffer.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return snippets;
    }

    protected static File[] findSnippetFiles(File snippetDirectory) {
        File[] plistFiles = snippetDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("plist") || name.endsWith("tmSnippet");
            }
        });
        return plistFiles;
    }

    public static void convert(File snippetsDir, String outputFilePath) throws IOException {
        List<String> snippets = SnippetConverter.convert(snippetsDir);
        if (snippets == null || snippets.isEmpty()) {
            return;
        }
        Writer writer = null;
        try {
            File outFile = new File(outputFilePath);
            outFile.getParentFile().mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            for (String snippet : snippets) {
                writer.write(snippet);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    static Map<String, String> uuidNameMap(File snippetDirectory) {
        HashMap<String, String> snippets = new HashMap<String, String>();
        File[] plistFiles = SnippetConverter.findSnippetFiles(snippetDirectory);
        if (plistFiles == null) {
            return snippets;
        }
        File[] fileArray = plistFiles;
        int n = plistFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File plistFile = fileArray[n2];
            try {
                Map<String, Object> properties = BundleConverter.parse(plistFile);
                if (properties != null) {
                    String name = BundleConverter.sanitize(properties, "name");
                    String uuid = (String)properties.get("uuid");
                    snippets.put(uuid, name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return snippets;
    }
}

